package com.acme.fileserver.service;

import com.acme.fileserver.model.User;
import com.acme.fileserver.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class UserService {
    
    @Autowired
    private UserRepository userRepository;
    
    @Autowired
    private AuthService authService;
    
    public List<User> getAllUsers() {
        return userRepository.findAll();
    }
    
    public Optional<User> getUserById(Long id) {
        return userRepository.findById(id);
    }
    
    public Optional<User> getUserByUsername(String username) {
        return userRepository.findByUsername(username);
    }
    
    // VULN: SQL Injection - unsafe query with user input
    public List<User> searchUsersUnsafe(String searchTerm) {
        // VULN: Direct string concatenation in query
        return userRepository.findByUsernameUnsafe(searchTerm);
    }
    
    // VULN: Insecure Direct Object Reference - no authorization
    public User updateUser(Long userId, String email, String fullName) {
        Optional<User> userOpt = userRepository.findById(userId);
        if (userOpt.isPresent()) {
            User user = userOpt.get();
            // VULN: No authorization check - any user can update any user
            user.setEmail(email);
            user.setFullName(fullName);
            return userRepository.save(user);
        }
        return null;
    }
    
    // VULN: Weak password update - no old password verification
    public boolean updatePassword(Long userId, String newPassword) {
        Optional<User> userOpt = userRepository.findById(userId);
        if (userOpt.isPresent()) {
            User user = userOpt.get();
            // VULN: No verification of old password
            user.setPassword(authService.hashPassword(newPassword));
            userRepository.save(user);
            return true;
        }
        return false;
    }
    
    // VULN: Mass Assignment - updating all fields without validation
    public User updateUserUnsafe(User userData) {
        Optional<User> userOpt = userRepository.findById(userData.getId());
        if (userOpt.isPresent()) {
            User user = userOpt.get();
            // VULN: Mass assignment - copying all fields including role
            user.setEmail(userData.getEmail());
            user.setFullName(userData.getFullName());
            user.setRole(userData.getRole()); // VULN: Privilege escalation
            user.setActive(userData.isActive());
            return userRepository.save(user);
        }
        return null;
    }
}
