package com.acme.fileserver.service;

import com.acme.fileserver.model.FileEntity;
import com.acme.fileserver.model.User;
import com.acme.fileserver.repository.FileRepository;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@Service
public class FileService {
    
    @Autowired
    private FileRepository fileRepository;
    
    @Value("${file.upload.dir:uploads}")
    private String uploadDir;
    
    // VULN: Path Traversal - no validation of file paths
    public FileEntity uploadFile(MultipartFile file, Long userId, String description) throws IOException {
        String originalFilename = file.getOriginalFilename();
        
        // VULN: Path Traversal - direct use of user-provided filename
        String filepath = uploadDir + File.separator + originalFilename;
        
        // Create upload directory if it doesn't exist
        Path uploadPath = Paths.get(uploadDir);
        if (!Files.exists(uploadPath)) {
            Files.createDirectories(uploadPath);
        }
        
        // VULN: No file type validation
        // VULN: No file size validation beyond Spring config
        File targetFile = new File(filepath);
        file.transferTo(targetFile);
        
        FileEntity fileEntity = new FileEntity();
        fileEntity.setFilename(originalFilename);
        fileEntity.setFilepath(filepath);
        fileEntity.setOwnerId(userId);
        fileEntity.setFileSize(file.getSize());
        fileEntity.setContentType(file.getContentType());
        fileEntity.setDescription(description);
        
        return fileRepository.save(fileEntity);
    }
    
    // VULN: Path Traversal - allows directory traversal
    public File downloadFile(Long fileId, Long userId) {
        Optional<FileEntity> fileOpt = fileRepository.findById(fileId);
        if (fileOpt.isPresent()) {
            FileEntity fileEntity = fileOpt.get();
            // VULN: Insecure Direct Object Reference - no authorization check
            // Should check if user owns file or if file is public
            return new File(fileEntity.getFilepath());
        }
        return null;
    }
    
    // VULN: Path Traversal - direct path construction from user input
    public File downloadFileByPath(String filepath) {
        // VULN: No path validation - allows ../../../etc/passwd
        return new File(filepath);
    }
    
    public List<FileEntity> getUserFiles(Long userId) {
        return fileRepository.findByOwnerId(userId);
    }
    
    public List<FileEntity> getPublicFiles() {
        return fileRepository.findByIsPublicTrue();
    }
    
    // VULN: Insecure Direct Object Reference - no authorization
    public boolean deleteFile(Long fileId, Long userId) {
        Optional<FileEntity> fileOpt = fileRepository.findById(fileId);
        if (fileOpt.isPresent()) {
            FileEntity fileEntity = fileOpt.get();
            // VULN: Missing authorization check
            File file = new File(fileEntity.getFilepath());
            if (file.exists()) {
                file.delete();
            }
            fileRepository.delete(fileEntity);
            return true;
        }
        return false;
    }
    
    // VULN: Command Injection - executing system commands
    public String getFileInfo(String filename) {
        try {
            // VULN: Command Injection - user input directly in command
            Process process = Runtime.getRuntime().exec("file " + filename);
            java.io.BufferedReader reader = new java.io.BufferedReader(
                new java.io.InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            return output.toString();
        } catch (IOException e) {
            return "Error: " + e.getMessage();
        }
    }
}
