package com.acme.fileserver.service;

import com.acme.fileserver.model.Session;
import com.acme.fileserver.model.User;
import com.acme.fileserver.repository.SessionRepository;
import com.acme.fileserver.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Date;
import java.util.Optional;

@Service
public class AuthService {
    
    @Autowired
    private UserRepository userRepository;
    
    @Autowired
    private SessionRepository sessionRepository;
    
    // VULN: Weak password hashing - using MD5 (deprecated and insecure)
    public String hashPassword(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(password.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(hash);
        } catch (Exception e) {
            throw new RuntimeException("Password hashing failed", e);
        }
    }
    
    // VULN: Weak random number generation for session IDs
    public String generateSessionId() {
        // VULN: Using Math.random() instead of SecureRandom
        return Long.toString(System.currentTimeMillis()) + 
               Long.toString((long)(Math.random() * 1000000));
    }
    
    public User authenticate(String username, String password) {
        Optional<User> userOpt = userRepository.findByUsername(username);
        if (userOpt.isPresent()) {
            User user = userOpt.get();
            // VULN: Weak password comparison - using MD5 hash
            String hashedPassword = hashPassword(password);
            if (user.getPassword().equals(hashedPassword)) {
                user.setLastLogin(new Date());
                userRepository.save(user);
                return user;
            }
        }
        return null;
    }
    
    // VULN: SQL Injection vulnerability - direct string concatenation
    public User authenticateUnsafe(String username, String password) {
        // This method intentionally uses unsafe query construction
        // VULN: Direct SQL string concatenation
        String query = "SELECT * FROM users WHERE username = '" + username + 
                       "' AND password = '" + hashPassword(password) + "'";
        // In real implementation, this would execute raw SQL
        return userRepository.findByUsername(username).orElse(null);
    }
    
    public Session createSession(User user, HttpServletRequest request) {
        String sessionId = generateSessionId();
        Session session = new Session(sessionId, user.getId());
        session.setIpAddress(request.getRemoteAddr());
        session.setUserAgent(request.getHeader("User-Agent"));
        return sessionRepository.save(session);
    }
    
    public Optional<Session> validateSession(String sessionId) {
        Optional<Session> sessionOpt = sessionRepository.findBySessionId(sessionId);
        if (sessionOpt.isPresent()) {
            Session session = sessionOpt.get();
            // VULN: Session fixation - not regenerating session ID
            if (!session.isExpired()) {
                return sessionOpt;
            }
        }
        return Optional.empty();
    }
    
    public void logout(String sessionId) {
        sessionRepository.deleteBySessionId(sessionId);
    }
    
    public User registerUser(String username, String password, String email) {
        // VULN: No password strength validation
        // VULN: No email validation
        User user = new User(username, hashPassword(password), email);
        return userRepository.save(user);
    }
}
