package com.acme.fileserver.repository;

import com.acme.fileserver.model.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface UserRepository extends JpaRepository<User, Long> {
    
    Optional<User> findByUsername(String username);
    
    Optional<User> findByEmail(String email);
    
    // VULN: SQL Injection - using @Query with string concatenation
    @Query(value = "SELECT * FROM users WHERE username = '" + "#{username}" + "'", nativeQuery = true)
    List<User> findByUsernameUnsafe(String username);
    
    // VULN: SQL Injection - direct string concatenation in query
    @Query(value = "SELECT * FROM users WHERE role = ?1", nativeQuery = true)
    List<User> findByRoleUnsafe(String role);
}
