package com.acme.fileserver.repository;

import com.acme.fileserver.model.FileEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface FileRepository extends JpaRepository<FileEntity, Long> {
    
    List<FileEntity> findByOwnerId(Long ownerId);
    
    List<FileEntity> findByIsPublicTrue();
    
    // VULN: SQL Injection - unsafe query construction
    @Query(value = "SELECT * FROM files WHERE owner_id = " + "#{ownerId}", nativeQuery = true)
    List<FileEntity> findByOwnerIdUnsafe(Long ownerId);
}
