package com.acme.fileserver.model;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name = "sessions")
public class Session implements Serializable {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    private String sessionId;
    private Long userId;
    private Date createdAt;
    private Date expiresAt;
    private String ipAddress;
    private String userAgent;
    
    // Serialization vulnerability - no version UID
    // VULN: Insecure Deserialization
    
    public Session() {
        this.createdAt = new Date();
    }
    
    public Session(String sessionId, Long userId) {
        this();
        this.sessionId = sessionId;
        this.userId = userId;
        // VULN: Weak session expiration - fixed 30 minutes
        this.expiresAt = new Date(System.currentTimeMillis() + 30 * 60 * 1000);
    }
    
    // Getters and Setters
    public Long getId() {
        return id;
    }
    
    public void setId(Long id) {
        this.id = id;
    }
    
    public String getSessionId() {
        return sessionId;
    }
    
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
    
    public Long getUserId() {
        return userId;
    }
    
    public void setUserId(Long userId) {
        this.userId = userId;
    }
    
    public Date getCreatedAt() {
        return createdAt;
    }
    
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
    
    public Date getExpiresAt() {
        return expiresAt;
    }
    
    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }
    
    public String getIpAddress() {
        return ipAddress;
    }
    
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }
    
    public String getUserAgent() {
        return userAgent;
    }
    
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
    
    public boolean isExpired() {
        return expiresAt != null && expiresAt.before(new Date());
    }
}
