package com.acme.fileserver.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@RestController
@RequestMapping("/api")
public class ApiController {
    
    @Autowired
    private UserService userService;
    
    @Autowired
    private SessionRepository sessionRepository;
    
    @Autowired
    private UserRepository userRepository;
    
    // VULN: Insecure Deserialization - deserializing user-provided data
    @PostMapping("/deserialize")
    public Map<String, Object> deserialize(@RequestBody Map<String, String> request) {
        Map<String, Object> response = new HashMap<>();
        
        try {
            String serializedData = request.get("data");
            byte[] data = Base64.getDecoder().decode(serializedData);
            
            // VULN: Insecure Deserialization - no validation
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object obj = ois.readObject();
            ois.close();
            
            response.put("success", true);
            response.put("deserialized", obj.toString());
        } catch (Exception e) {
            response.put("success", false);
            response.put("error", e.getMessage());
        }
        
        return response;
    }
    
    // VULN: XXE (XML External Entity) - processing XML without protection
    @PostMapping("/xml/process")
    public Map<String, Object> processXml(@RequestBody String xmlData) {
        Map<String, Object> response = new HashMap<>();
        
        try {
            // VULN: XXE - DocumentBuilderFactory not configured securely
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            
            // VULN: No protection against XXE attacks
            org.w3c.dom.Document doc = builder.parse(new ByteArrayInputStream(xmlData.getBytes()));
            
            response.put("success", true);
            response.put("rootElement", doc.getDocumentElement().getNodeName());
        } catch (Exception e) {
            response.put("success", false);
            response.put("error", e.getMessage());
        }
        
        return response;
    }
    
    // VULN: Server-Side Request Forgery (SSRF)
    @GetMapping("/fetch")
    public Map<String, Object> fetchUrl(@RequestParam String url) {
        Map<String, Object> response = new HashMap<>();
        
        try {
            // VULN: SSRF - fetching user-provided URL without validation
            java.net.URL urlObj = new java.net.URL(url);
            java.net.HttpURLConnection conn = (java.net.HttpURLConnection) urlObj.openConnection();
            conn.setRequestMethod("GET");
            
            java.io.BufferedReader reader = new java.io.BufferedReader(
                new java.io.InputStreamReader(conn.getInputStream()));
            StringBuilder content = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            reader.close();
            
            response.put("success", true);
            response.put("content", content.toString());
        } catch (Exception e) {
            response.put("success", false);
            response.put("error", e.getMessage());
        }
        
        return response;
    }
}
